/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util.swing;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;

public class FrameBoundsTracker {
    private final Rectangle bounds = new Rectangle(-1, -1, -1, -1);
    private final Rectangle shared = new Rectangle();
    private final Rectangle initial;
    private final Frame frame;
    private boolean maxVert;
    private boolean maxHoriz;

    public FrameBoundsTracker(Frame frame) {
        this.frame = frame;
        this.initial = frame.getBounds();
        frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                FrameBoundsTracker.this.trackBounds();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                FrameBoundsTracker.this.trackBounds();
            }
        });
        frame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                FrameBoundsTracker.this.updateExtendedState(windowEvent.getNewState());
            }
        });
        this.trackBounds();
    }

    public String toString() {
        return "[ " + this.getMaximizedState() + " : " + this.bounds.x + "," + this.bounds.y + " ; " + this.bounds.width + "," + this.bounds.height + " ]";
    }

    public boolean hasBoundsChanged() {
        return !this.initial.equals(this.getNormalBounds());
    }

    public Rectangle getNormalBounds() {
        return this.bounds;
    }

    public int getMaximizedState() {
        return (this.maxHoriz ? 2 : 0) + (this.maxVert ? 4 : 0);
    }

    void trackBounds() {
        this.updateExtendedState(this.frame.getExtendedState());
        this.updateBounds();
    }

    void updateExtendedState(int n) {
        this.maxHoriz = (2 & n) != 0;
        this.maxVert = (4 & n) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBounds() {
        if (!this.maxHoriz || !this.maxVert) {
            Rectangle rectangle = this.shared;
            synchronized (rectangle) {
                this.frame.getBounds(this.shared);
                if (!this.maxHoriz) {
                    this.bounds.x = this.shared.x;
                    this.bounds.width = this.shared.width;
                }
                if (!this.maxVert) {
                    this.bounds.y = this.shared.y;
                    this.bounds.height = this.shared.height;
                }
            }
        }
    }
}

